clear;
clc;
%the dpi so that we can get the answer in inches
dpi = 100;
%load the image

%cycle through each row
deg_list = 1:90;
for deg=1:90
    
    [theimage,~,~] = imread('square2.bmp');
    theimage = double(theimage);
    theimage = theimage/255;

    [x,y,z] = size(theimage);
    
    for j=1:y
        %go through each column
        for i=1:x
            %check to see if the pixel is dark enough to be considered filled
            %in
            if theimage(i,j,1)*theimage(i,j,2)*theimage(i,j,3) < .3
                %if its dark fill it completely black,
                theimage(i,j,1) = 0;
                theimage(i,j,2) = 1;
                theimage(i,j,3) = 0;
            else
                %turn pixels white if they are not selected
                theimage(i,j,1) = 1;
                theimage(i,j,2) = 1;
                theimage(i,j,3) = 1;
            end
         end
    end

    if deg == 0 
        image(min(max(theimage,0),1));
        axis image
        figure
    end




    theimage = imrotate(theimage,deg);
    %get the size of the image, in x and y and z
    [x,y,z] = size(theimage);
    %set some variables we will use later
    avg_x = 0;
    avg_y = 0;
    num_x = 0;
    num_y = 0;

    %cycle through each row
    for j=1:y
        %go through each column
        for i=1:x
            %check to see if the pixel is dark enough to be considered filled
            %in
            if theimage(i,j,1) == 0 && theimage(i,j,2) == 1 && theimage(i,j,3) ==0
                %add to the average x and y values and pixel counts
                avg_x = avg_x + i;
                avg_y = avg_y + j;
                num_x = num_x + 1;
                num_y = num_y + 1;
            else
                %turn pixels white if they are not selected
                theimage(i,j,1) = 1;
                theimage(i,j,2) = 1;
                theimage(i,j,3) = 1;
            end
         end
    end

    %calculate the centroid by simply taking the average x and y values
    cent_x = floor(avg_x / num_x);
    cent_y = floor(avg_y / num_y);

    %color the centriod red so that we can see it
    theimage(cent_x,cent_y,1) = 1;
    theimage(cent_x,cent_y,2) = 0;
    theimage(cent_x,cent_y,3) = 0;


    %set some variables we will use
    i_x = 0;
    i_y = 0;


    for j=1:y
        %go through each column
        for i=1:x
            if theimage(i,j,1) == 0 && theimage(i,j,2) == 1 && theimage(i,j,3) ==0

                %add to the i_x and i_y variables the i for a square and then
                %use the parallel axis theorm to shift it
                i_x = i_x + ((1/dpi)*(1/dpi)^3)/12 + ((i - cent_x)/dpi)^2 * (1/dpi)^2;
                i_y = i_y + ((1/dpi)*(1/dpi)^3)/12 + ((j - cent_y)/dpi)^2 * (1/dpi)^2;

            end
         end
    end
    ix(deg) = i_x;
    iy(deg) = i_y;
    deg
    
    image(min(max(theimage,0),1));
    axis image

end


figure
scatter(deg_list,ix,4,'filled')
hold on;
scatter(deg_list,iy,4,'filled')
axis([0 90 0 .1])
legend('ix','iy')


